<?php 
// Initialisation client SOAP et authentification placée dans le Header
$oWS =  new SoapClient("http://exe.idylis.com/idylisapi.asmx?wsdl");
$oSessionId=$oWS->authentification1(array('_codeAbonne'=>'MonCodeAbonné', '_identifiant'=>'MonIdentifiant', '_motdePasse'=>'MotMotPasse'));
$oAuth['SessionID']= $oSessionId->AuthentificationAvec3Parametres1Result;
$oHeader= new SoapHeader('https://www.idylis.com/Idylisapi.asmx/','SessionIDHeader',$oAuth, false);
$oWS->__setSoapHeaders(array($oHeader));

// Appel de la méthode pour modifier la connexion à la base de données en fonction du module à utiliser, ici Comptabilité
$oWS->DefinirModule(array('_codemodule'=>'CP'));

// On appelle la méthode de lecture pour récupérer les écritures comptables des fournisseurs
$oEcrituresFournisseurs=$oWS->LireTable(array('_nomtable'=>"CP_Ecritures", '_criteres'=>"NumeroCompte LIKE'401%'", '_ordre'=>"NUMEROCOMPTE ASC", '_soustables'=>"0", '_pieceatache'=>"0", '_aveccompression'=>"0"));
// La réponse SOAP (XML) sera traitée à partir de la classe SimpleXMLElement
$oEcrituresFournXML= new SimpleXMLElement($oEcrituresFournisseurs->LireTableResult);

// Si la réponse renvoie un résultat avec des écritures, on poursuit le traitement
if(isset($oEcrituresFournXML->FICHE[0]->NUMEROCOMPTE)){
	// Initialisation d'un tableau avec les données pour le virement
	$oVirFournisseur[0]['Numerocompte']=$oEcrituresFournXML->FICHE[0]->NUMEROCOMPTE;
	$oVirFournisseur[0]['Debit']=str_replace(',','.',$oEcrituresFournXML->FICHE[0]->DEBIT);
	$oVirFournisseur[0]['Credit']=str_replace(',','.',$oEcrituresFournXML->FICHE[0]->CREDIT);
//print_r($oVirFournisseur)[0]['Credit'];
	// Connexion à la base de données de la gestion commerciale
	$oWS->DefinirModule(array('_codemodule'=>'FA'));

	// Lecture de la fiche fournisseur à partir du compte comptable récupéré dans les écritures pour obtenir les coordonnées bancaires
	$oFournisseur=$oWS->LireTable(array('_nomtable'=>"FB_Fournisseurs", '_criteres'=>"COMP_COMPTABLE =".$oEcrituresFournXML->FICHE[0]->NUMEROCOMPTE."", '_ordre'=>"", '_soustables'=>"0", '_pieceatache'=>"0", '_aveccompression'=>"0"));
	$oFournisseurXML= new SimpleXMLElement($oFournisseur->LireTableResult);
	// Ajout des infos bancaires au tableau des virements et initialisation compteur de fournisseur
	$oVirFournisseur[0]['IBAN']=$oFournisseurXML->FICHE[0]->IBAN;
	$oVirFournisseur[0]['CODEBICSWIFT']=$oFournisseurXML->FICHE[0]->CODEBICSWIFT;
	$oVirFournisseur[0]['NOM']=$oFournisseurXML->FICHE[0]->NOM;
	$nNumFournisseur=0;

	// On boucle sur les écritures, si le numéro de compte fournisseur est identique au précédent, on cumule, sinon on passe au fournisseur suivant
	for($i=1; $i<count($oEcrituresFournXML->FICHE);$i++){
		
		If (strcmp($oEcrituresFournXML->FICHE[$i]->NUMEROCOMPTE,$oEcrituresFournXML->FICHE[$i-1]->NUMEROCOMPTE) == 0){
			$oVirFournisseur[$nNumFournisseur]['Debit']=floatval($oVirFournisseur[$nNumFournisseur]['Debit'])+floatval(str_replace(',','.',$oEcrituresFournXML->FICHE[$i]->DEBIT));
			$oVirFournisseur[$nNumFournisseur]['Credit']=floatval($oVirFournisseur[$nNumFournisseur]['Credit'])+floatval(str_replace(',','.',$oEcrituresFournXML->FICHE[$i]->CREDIT));
			print_r($oVirFournisseur);
		}	
		Else{
			$nNumFournisseur++;
			$oVirFournisseur[$nNumFournisseur]['Numerocompte']=$oEcrituresFournXML->FICHE[$i]->NUMEROCOMPTE;
			$oVirFournisseur[$nNumFournisseur]['Debit']=str_replace(',','.',$oEcrituresFournXML->FICHE[$i]->DEBIT);
			$oVirFournisseur[$nNumFournisseur]['Credit']=str_replace(',','.',$oEcrituresFournXML->FICHE[$i]->CREDIT);
			$oFournisseur=$oWS->LireTable(array('_nomtable'=>"FB_Fournisseurs", '_criteres'=>"COMP_COMPTABLE =".$oEcrituresFournXML->FICHE[$i]->NUMEROCOMPTE."", '_ordre'=>"", '_soustables'=>"0", '_pieceatache'=>"0", '_aveccompression'=>"0"));
			$oFournisseurXML= new SimpleXMLElement($oFournisseur->LireTableResult);
			$oVirFournisseur[$nNumFournisseur]['IBAN']=$oFournisseurXML->FICHE[0]->IBAN;	
			$oVirFournisseur[$nNumFournisseur]['CODEBICSWIFT']=$oFournisseurXML->FICHE[0]->CODEBICSWIFT;
			$oVirFournisseur[$nNumFournisseur]['NOM']=$oFournisseurXML->FICHE[0]->NOM;
		}
	}
	
	// Boucle pour calculer à quel(s) fournisseur(s) faire un virement (compte créditeur), et appel de la méthode d'insertion dans la table Virements
	for ($j=0; $j<count($oVirFournisseur); $j++){
		if (($oVirFournisseur[$j]['Credit']-$oVirFournisseur[$j]['Debit'])>0){
			$oVirLBA[$j]['CODEFOURNISSEUR']=$oVirFournisseur[$j]['Numerocompte'];
			$oVirLBA[$j]['MONTANTVIRER']=$oVirFournisseur[$j]['Credit']-$oVirFournisseur[$j]['Debit'];
			$oVirLBA[$j]['IBAN']=$oVirFournisseur[$j]['IBAN'];
			$oVirLBA[$j]['DATEVIREMENT']=date("d/m/20y");
			$oVirLBA[$j]['REFERENCE']=date("d.m.y").+$j;
			$oVirLBA[$j]['CODESWIFT']=$oVirFournisseur[$j]['CODEBICSWIFT'];
			$oVirLBA[$j]['B_NOM']=$oVirFournisseur[$j]['NOM'];
			$cFiche= "<LB_VIREMENTS><FICHE><CODEFOURNISSEUR>".$oVirLBA[$j]['CODEFOURNISSEUR']."</CODEFOURNISSEUR><MONTANTVIRER>".$oVirLBA[$j]['MONTANTVIRER']."</MONTANTVIRER><CODEBICSWIFT>".$oVirLBA[$j]['CODESWIFT']."</CODEBICSWIFT><REFERENCE>".$oVirLBA[$j]['REFERENCE']."</REFERENCE><B_NOM>".$oVirLBA[$j]['B_NOM']."</B_NOM><DATEVIREMENT>".$oVirLBA[$j]['DATEVIREMENT']."</DATEVIREMENT><IBAN>".$oVirLBA[$j]['IBAN']."</IBAN></FICHE></LB_VIREMENTS>";
			//Appel de la méthode d'insertion avec en paramètre une chaîne XML "cFiche" correspondant au virement à insérer
			$oWS->InsererTable(array('_cFiche'=>$cFiche));
		}
	}
}

?>